/* -------------------------------------
// 
// cookie.js
// 
// Copyright (c) 2008 mukairiku
// All rights reserved.
// http://www.mukairiku.net/
// 
// -----------------------------------*/


// ONbL[擾
function GetCookie(name){
  var namepart  = name + "=";
  var nlength   = namepart.length;
  var clength   = document.cookie.length;
  var i = 0;
  
  while(i+nlength < clength){
    var offset = i + nlength;
    if(document.cookie.substring(i, offset) == namepart ){
      var endpoint = document.cookie.indexOf(";", offset);
      if(endpoint == -1){
        endpoint = document.cookie.length;
      }
      return unescape(document.cookie.substring(offset, endpoint));
    }
    i = document.cookie.indexOf(" ", i) + 1;
    if(i == 0){
      break;
    }
  }
  return "";
}


// NbL[ɒlۑB
function SetCookie(name, value, expires, path, domain, secure){
  document.cookie = name + "=" + escape(value) +
    ((expires) ? "; expires=" + expires : "") +
    ((path) ? "; path=" + path : "") +
    ((domain) ? "; domain=" + domain : "") +
    ((secure) ? "; secure" : "");
}


// NbL[폜
function DelCookie(name, path, domain){
  document.cookie = name + "=" +
    ((path) ? "; path=" + path : "") +
    ((domain) ? "; domain=" + domain : "") +
    "; expires=Thu, 01-Jan-70 00:00:01 GMT";
}


// NbL[̗L쐬
function getExpDate(days, hours, minutes){
  if(typeof days    != "number"){
    days = 0;
  }
  if(typeof hours   != "number"){
    hours = 0;
  }
  if(typeof minutes != "number"){
    minutes = 0;
  }
  
  if(days == 0 && hours == 0 && minutes == 0){
    return "Thu, 01-Jan-70 00:00:01 GMT";
  }
  
  var expDate = new Date();
  expDate.setDate(expDate.getDate() + parseInt(days));
  expDate.setHours(expDate.getHours() + parseInt(hours));
  expDate.setMinutes(expDate.getMinutes() + parseInt(minutes));
  return expDate.toGMTString();
}


